<?php
/**
 * 子主题设置选项
 *
 * @package    Xun Child
 * @subpackage Options
 * @since      1.0.0
 * @author     June
 * @link       https://www.xuntheme.com
 */

// 防止直接访问
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// 检查 CSF 框架是否可用（由父主题加载）
if ( ! class_exists( 'CSF' ) ) {
    return;
}

/**
 * 子主题设置选项 ID
 */
define( 'XUN_CHILD_OPTIONS_ID', 'xun_child_options' );

/**
 * 加载父主题的 CSF 自定义样式
 *
 * @since 1.0.0
 */
add_action( 'admin_enqueue_scripts', function( $hook ) {
    if ( strpos( $hook, 'xun-child-options' ) !== false ) {
        wp_enqueue_style(
            'xun-admin-options',
            get_template_directory_uri() . '/assets/css/admin/admin-style.css',
            [ 'csf' ],
            XUN_VERSION
        );
    }
} );

/**
 * 创建子主题设置面板
 *
 * @since 1.0.0
 */
CSF::createOptions( XUN_CHILD_OPTIONS_ID, [
    'menu_title'         => __( '子主题设置', 'xun-child' ),
    'menu_slug'          => 'xun-child-options',
    'menu_type'          => 'submenu',
    'menu_parent'        => 'xun-options',
    'framework_title'    => __( '子主题设置', 'xun-child' ),
    'framework_class'    => 'xun-csf-custom', 
    'class'              => 'xun-csf-custom',
    'theme'              => 'light',
    'show_bar_menu'      => false,
    'show_reset_all'     => true,
    'show_reset_section' => true,
    'show_footer'        => true,
    'sticky_header'      => true,
    'save_defaults'      => true,
    'ajax_save'          => true,
    'footer_text'        => __( 'Xun Child v' . XUN_CHILD_VERSION, 'xun-child' ),
    'footer_credit'      => __( '子主题自定义设置', 'xun-child' ),
    'database'           => 'option',
] );

/**
 * 说明页面
 *
 * @since 1.0.0
 */
CSF::createSection( XUN_CHILD_OPTIONS_ID, [
    'id'     => 'child_welcome',
    'title'  => __( '说明', 'xun-child' ),
    'icon'   => 'fas fa-info-circle',
    'fields' => [
        [
            'type'    => 'content',
            'content' => '
                <div style="padding: 20px; background: #f9f9f9; border-radius: 8px;">
                    <h2 style="margin-top: 0;">' . __( '子主题设置', 'xun-child' ) . '</h2>
                    <p>' . __( '这是 Xun 子主题的设置面板。您可以在此处添加子主题专属的自定义选项。', 'xun-child' ) . '</p>
                    <p style="color: #666;">' . __( '子主题版本：', 'xun-child' ) . XUN_CHILD_VERSION . '</p>
                </div>
            ',
        ],
    ],
] );
