<?php
/**
 * Xun Child 子主题入口文件
 *
 * 子主题的核心入口，用于添加自定义功能
 * 此文件中的代码会在父主题加载后执行
 *
 * @package    Xun Child
 * @since      1.0.0
 * @author     June
 * @link       https://www.xuntheme.com
 */

// 防止直接访问
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * 定义子主题常量
 */
define( 'XUN_CHILD_VERSION', '1.0.0' );

/**
 * ============================================================================
 * 子主题初始化
 * ============================================================================
 */

/**
 * 子主题设置
 *
 * 在父主题设置完成后执行
 * 使用 xun_after_theme_setup 钩子确保父主题已完成初始化
 *
 * @since 1.0.0
 */
add_action( 'xun_after_theme_setup', function() {
    // 在此添加子主题的设置代码
    // 例如：注册额外的导航菜单、添加主题支持等
    
    // 示例：注册额外的导航菜单
    // register_nav_menus( [
    //     'footer' => __( '页脚菜单', 'xun-child' ),
    // ] );
} );

/**
 * ============================================================================
 * 自定义脚本和样式
 * ============================================================================
 */

/**
 * 加载子主题自定义脚本
 *
 * 父主题会自动加载子主题的 style.css 和 assets/css/style.css
 * 如果需要加载额外的脚本或样式，在此添加
 *
 * @since 1.0.0
 */
add_action( 'xun_after_enqueue_scripts', function() {
    // 加载子主题 SPA 适配脚本
    $child_spa_script = XUN_CHILD_DIR . '/assets/js/child-spa.js';
    if ( file_exists( $child_spa_script ) ) {
        wp_enqueue_script(
            'xun-child-spa',
            XUN_CHILD_URI . '/assets/js/child-spa.js',
            [ 'xun-script' ],
            filemtime( $child_spa_script ),
            true
        );
    }
} );


/**
 * ============================================================================
 * 加载子主题模块
 * ============================================================================
 */

/**
 * 加载子主题设置面板
 *
 * 在 init 钩子中加载
 *
 * @since 1.0.0
 */
add_action( 'init', function() {
    $theme_options = get_stylesheet_directory() . '/inc/options/theme-options.php';
    if ( file_exists( $theme_options ) ) {
        require_once $theme_options;
    }
} );


/* 在此添加您的自定义功能代码... */
