/**
 * 子主题 SPA 适配脚本
 *
 * 统一处理首次加载与 SPA 切换后的初始化
 *
 * @package    Xun Child
 * @since      1.0.0
 */

(() => {
    /**
     * 初始化子主题功能
     *
     * 这里放置需要在“首次加载 + SPA 切换后”重复执行的逻辑
     */
    const initChildFeatures = () => {
        // 示例：重新绑定子主题按钮事件
        // document.querySelectorAll('.xunchild-demo-btn').forEach((btn) => {
        //     if (btn.dataset.bound === '1') return;
        //     btn.dataset.bound = '1';
        //     btn.addEventListener('click', () => {
        //         // 你的逻辑
        //     });
        // });
    };

    // 首次加载
    document.addEventListener('DOMContentLoaded', () => {
        initChildFeatures();
    });

    // SPA 模式：切换完成后重新初始化
    if (window.xunData?.enableSpa) {
        window.addEventListener('spa:loaded', () => {
            initChildFeatures();
        });

        // 用户中心子页面切换完成后触发（可选）
        window.addEventListener('userCenterPageLoaded', (e) => {
            const page = e?.detail?.page || '';
            if (!page) return;
            // 按需对不同子页面做增强
            // if (page === 'orders') {
            //     initChildFeatures();
            // }
        });
    }
})();
